 ; Ŀ
 ;   Lili - chop, reorder, and suck a csv file into an Isogen iso.         
 ;   Copyright 2007, 2008 by Rocket Software Ltd.                          
 ;                                                                         
 ; 

 ; Ŀ
 ;   Ogre - log an error.                                                  
 ; 
 (DEFUN OGRE (errmsg / len namm dat fn)
 ; Ŀ
 ;   Concoct a filename.                                                   
 ; 
  (setq len (strlen (setq namm (getvar "dwgname"))))
  (if (= (strcase (substr namm (- len 3)) t) ".dwg")
         (setq namm (substr namm 1 (- len 4))))
 ; Ŀ
 ;   Make the error string, file it.                                       
 ; 
  (setq dat (strcat namm ", " errmsg))
  (setq fn (open (strcat (getvar "dwgprefix") "Error.log") "a"))
  (write-line dat fn)
  (close fn)
 (princ))
 ; Ŀ
 ;   Ogre end.                                                             
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   a list of the (possibly modified) target string and the number of     
 ;   changes made.                                                         
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Clast - split a string at the last dash.                   
 ;   Argument: Linn, a string.                                             
 ;   Calls nothing.                                                        
 ;   Returns a list of two strings or nil if no dash was found.            
 ; 
 (DEFUN CLAST (linn / pos lin1 lin2)
  (setq pos (strlen linn))
  (while (>= pos 1)
         (if (= (substr linn pos 1) "-")
             (progn
                  (setq lin1 (substr linn 1 (1- pos)))
                  (setq lin2 (substr linn (1+ pos)))
                  (setq pos 0))
             (setq pos (1- pos))))
 (if lin1 (list lin1 lin2) nil))
 ; Ŀ
 ;   Clast end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Csplit - divide a text string at commas, make into a list  
 ;   of substrings.                                                        
 ; 
 (DEFUN CSPLIT (linn / len llen pos name1 strlst)
 ; Ŀ
 ;   First knock off leading spaces.  This prevents a string consisting    
 ;   only of spaces from getting into the main loop and crashing.          
 ; 
  (while (and (= (substr linn 1 1) " ")
              (/= (strlen linn) 0))
         (setq linn (substr linn 2)))
 ; Ŀ
 ;   Now process the string.  Note that the space remover is still         
 ;   required for leading spaces in individual fields.                     
 ; 
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) ",")   ; character to split on
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (and (/= 0 (setq llen (strlen name1)))
                     (= (substr name1 llen) " "))
                (setq name1 (substr name1 1 (1- llen))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Csplit end.                                                           
 ; 

 ; Ŀ
 ;   Dirgg - get a list of drawing filenames in a directory.               
 ;   Currently takes no arguments.                                         
 ;   Returns a list: the path, and a list of filenames with paths.         
 ; 
 (DEFUN DIRGG (pat pref / fils num fnam nulis)
  (setq fils (vl-directory-files pref pat 1))
 ; Ŀ
 ;   Put the filename list in alphabetical order.                          
 ; 
  (if fils (setq fils (acad_strlsort fils)))
  (setq num 0)
 ; Ŀ
 ;   Add the directory prefix to each name.                                
 ; 
  (while (and fils (setq fnam (nth num fils)))
         (setq num (1+ num))
         (setq fnam (strcat pref fnam))
         (setq nulis (cons fnam nulis)))
 (list pref (reverse nulis)))
 ; Ŀ
 ;   Dirgg end.                                                            
 ; 

 ; Ŀ
 ;   Ftx - find and extract several specific text strings.                 
 ;   Takes no arguments, calls Poxx.                                       
 ;   Returns a list: ("Drawing n of n" "Line Number" "Spec" ss) where      
 ;   ss is a selection set of all the entities found.                      
 ;   Note that while only text is extracted, lines and polylines are       
 ;   included in the ss.                                                   
 ; 
 (DEFUN FTX (/ osna enam entt pa ds llxp llyp urxp uryp ll ur ss num str
                                                          ofdwgs lineno spec)
  (setq osna (getvar "osmode"))
  (setvar "osmode" 0) 
 ; Ŀ
 ;   Find the corners of the selection area.                               
 ; 
  (if (setq enam (ssname (ssget "x" (list (cons 2 "Tridyne_Tb_D"))) 0))
      (progn
           (setq entt (entget enam))
           (setq pa (cdr (assoc 10 entt)))
           (setq ds (cdr (assoc 41 entt)))
           (setq llxp (+ (car pa) (* 490 ds)))
           (setq llyp (+ (cadr pa) (* 50 ds)))
           (setq urxp (+ (car pa) (* 672 ds)))
           (setq uryp (+ (cadr pa) (* 130 ds)))
           (setq ll (list llxp llyp))
           (setq ur (list urxp uryp))
           (poxx ll ur 140)
 ; Ŀ
 ;   Find all text and lines in the selected area.                         
 ; 
           (setq ss (ssget "w" ll ur '((-4 . "<or") (0 . "text") (0 . "line")
                                       (0 . "polyline") (0 . "lwpolyline")
                                       (-4 . "or>"))))
 ; Ŀ
 ;   Extract the line and the DRG text.                                    
 ; 
           (setq num 0)
           (while (and ss (setq enam (ssname ss num)))
                  (setq num (1+ num))
                  (setq entt (entget enam))
                  (if (setq str (cdr (assoc 1 entt)))
                      (cond ((wcmatch str "* OF *")
                             (setq ofdwgs str))
                            ((wcmatch str "*\"-*")
                             (setq lineno str))
                            ((wcmatch str "*-*-*")
                             (setq spec str)))))))
  (setvar "osmode" osna)
 ; Ŀ
 ;   Return the three desired strings.                                     
 ; 
 (if (null ofdwgs) (setq ofdwgs "1 of 1"))
 (list (strcat "DRAWING " ofdwgs) lineno spec ss))
 ; Ŀ
 ;   Subroutine Ftx end.                                                   
 ; 

 ; Ŀ
 ;   Lilli - read a csv line list into a list of much neater lists of      
 ;   strings.                                                              
 ;   Arguments: Filnam, a file name.                                       
 ;   Calls ... numerous things.  Returns a list of lists of strings.       
 ;   The first field in each sublist is a line number.                     
 ; 
 (DEFUN LILLI (filnam / fn linn malist num field1 str gnulis)
 ; Ŀ
 ;   While there are lines in the file, process them.                      
 ; 
  (if (and filnam (setq fn (open filnam "r")))
      (progn
           (while (setq linn (read-line fn))
 ; Ŀ
 ;   Ignore any lines which are empty or in which the first character      
 ;   isn't a double quote (i.e. the first field is a pipe size in inches.) 
 ;   (read "\"") causes a malformed string error.                          
 ; 
                  (if (and (/= linn "")
                           (= (substr linn 1 1) "\""))
                      (progn
                           (setq linn (nook linn))
                           (setq linn (csplit linn))
                           (setq linn (reinch linn))
                           (if (notmt linn)
                               (setq malist (cons linn malist))))))
           (close fn)))
 ; Ŀ
 ;   Rearrange them into the Isogen format.                                
 ; 
  (setq num 0)
  (while (setq linn (nth num malist))
         (setq num (1+ num))
 ; Ŀ
 ;   Make the first field (the line number).                               
 ; 
         (setq field1 (strcat (car linn)    "-"
                              (caddr linn)  "-"
                              (cadddr linn) "-"
                              (car (cddddr linn))))
         (if (not (member (setq str (nth 5 linn)) '("" " " "  " "-")))
             (setq field1 (strcat field1 "-" str)))
         (if (not (member (setq str (nth 6 linn)) '("" " " "  " "-")))
             (setq field1 (strcat field1 "&" str)))
 ; Ŀ
 ;   Add fields in the order required for the block.                       
 ;   The line number must be first for the assoc function, but it comes    
 ;   after the Spec in the block; the spec will be added by the calling    
 ;   function.                                                             
 ; 
         (setq linn (list field1             ; 1  line number
                         (nth 9 linn)        ; 2  from
                         (nth 11 linn)       ; 3  to
                         (nth 16 linn)       ; 4  drawing number (pid ref)
                         ""                  ; 5  piping ref
                         "B31.3"             ; 6  code
                         (nth 17 linn)       ; 7  design kPag
                         (nth 20 linn)       ; 8  test kPag
                         (nth 23 linn)       ; 9  design temperature
                         (nth 28 linn)       ; 10 s.r.
                         (cond ((= (nth 27 linn) "R") ; 11 x-ray
                                "100%")
                               ((= (nth 27 linn) "RR")
                                "10%")
                               (t ""))
                         (nth 5 linn)        ; 12 insulation
                         (nth 24 linn)       ; 13 mdmt temperature
                         (if (member (nth 29 linn) '("PRIME" "PAINT"))
                             "YES" "NO")     ; 14 prime
                         (if (= (nth 29 linn) "PAINT")
                             "YES" "NO")     ; 15 paint
                         (nth 6 linn)        ; 16 tracing
                         "SWEET"             ; 17 service
                         "SHOP"              ; 18 field/shop fab
                         ""                  ; 19 spare name
                         ""))                ; 20 spare value
 ; Ŀ
 ;   Remove commas from strings in the new list.                           
 ; 
         (setq linn (mapcar 'nocomma linn))
 ; Ŀ
 ;   Add the new list to the master list.                                  
 ; 
         (setq gnulis (cons linn gnulis)))
 gnulis)
 ; Ŀ
 ;   Lilli end.                                                            
 ; 

 ; Ŀ
 ;   Massoc - Multiple assoc.                                              
 ;   Arguments: Alis, a list of elements to test.                          
 ;              Asolis, the association list.                              
 ;   Reurns the first sublist matching an element from alis, or nil.       
 ; 
 (DEFUN MASSOC (alis asolis / num found suba)
  (setq num 0)
  (while (and (null found) (setq suba (nth num alis)))
         (setq num (1+ num))
         (setq found (assoc suba asolis)))
 found)
 ; Ŀ
 ;   Massoc end.                                                           
 ; 

 ; Ŀ
 ;   Nocomma - returns a string minus the commas.                          
 ; 
 (DEFUN NOCOMMA (aa / pos len bb)
  (setq pos 1)
  (setq len (strlen aa))
  (while (>= len pos)
         (setq bb (substr aa pos 1))
         (if (= bb ",")
             (setq aa (strcat (substr aa 1 (1- pos)) ";"
                              (substr aa (1+ pos)))))
         (setq pos (1+ pos)))
  aa)
 ; Ŀ
 ;   Nocomma end.                                                          
 ; 

 ; Ŀ
 ;   Nook - remove commas from strings which excel has encapsulated in     
 ;   double quotes so that Splat doesn't make one string into several.     
 ;   Takes one argument, the raw data string, returns it semi-processed.   
 ; 
 (DEFUN NOOK (linn / base pos nxchar inquot)
 ; Ŀ
 ;   Fields containing 38" are exported by Excel as "38""", so call Chug   
 ;   to change them to "38" which the cond section can handle.             
 ;   Later: """ is changed to |+", the cond section changes "38|+" to      
 ;   38|+ and the final insertion code must call Reinch to change this     
 ;   back to 38".                                                          
 ;   Similarly commas in double quotes are changed to ^| and after Csplit  
 ;   has chopped the string up into fields the attribute inserter calls    
 ;   Chug to change ^| back into a comma.                                  
 ; 
  (setq linn (car (chug "\"\"\"" "|+\"" linn)))
  (setq base "")
  (setq pos 1)
  (while (/= "" (setq nxchar (substr linn pos 1)))
         (setq pos (1+ pos))
         (cond ((and (null inquot) (= nxchar "\""))
                (setq inquot t))
               ((and inquot (= nxchar "\""))
                (setq inquot ()))
               ((and inquot (= nxchar ","))
                (setq base (strcat base "^|")))
               (t
                (setq base (strcat base nxchar)))))
 base)
 ; Ŀ
 ;   Nook end.                                                             
 ; 

 ; Ŀ
 ;   NotMt - see if a list contains anything but empty strings.            
 ;   Arguments: Lista, a list.                                             
 ;   Calls nothing, returns T = ok, or nil = empty.                        
 ; 
 (DEFUN NOTMT (lista / sub)
  (while (and (setq sub (car lista))
              (= sub ""))
         (setq lista (cdr lista)))
 (if lista t nil))
 ; Ŀ
 ;   NotMt end.                                                            
 ; 

 ; Ŀ
 ;   Poxx: draw a temporary marker box.                                    
 ;   Arguments: Pa, a corner point.                                        
 ;              Pb, another corner point.                                  
 ;              Colo, a colour number.                                     
 ; 
 (defun poxx (aa cc colo / num numdiv bb dd)
  (setq num 100)
  (setq numdiv 16)
  (setq bb (cons (car cc) (cdr aa)))
  (setq dd (cons (car aa) (cdr cc)))
  (grdraw aa bb 130)
  (grdraw bb cc 130)
  (grdraw cc dd 130)
  (grdraw dd aa 130)
  (repeat num
         (setq cc (polar cc (angle cc dd) (/ (distance cc dd) numdiv)))
         (grdraw bb cc colo)
         (setq dd (polar dd (angle dd aa) (/ (distance dd aa) numdiv)))
         (grdraw cc dd colo)
         (setq aa (polar aa (angle aa bb) (/ (distance aa bb) numdiv)))
         (grdraw dd aa colo)
         (setq bb (polar bb (angle bb cc) (/ (distance bb cc) numdiv)))
         (grdraw aa bb colo))
 (princ))
 ; Ŀ
 ;   Poxx end.                                                             
 ; 

 ; Ŀ
 ;   Reinch - Put back the commas and inch markers replaced by Nook.       
 ;   Arguments: Alist, a list of strings.                                  
 ;   Returns a list of strings.                                            
 ; 
 (DEFUN REINCH (alist / num sub gnu)
  (setq num 0)
  (while (setq sub (nth num alist))
         (setq num (1+ num))
         (setq sub (car (chug "^|" "," sub)))
         (setq sub (car (chug "|+" "\"" sub)))
         (setq gnu (append gnu (list sub))))
 gnu)
 ; Ŀ
 ;   Reinch end.                                                           
 ; 

 ; Ŀ
 ;   Valin - put new values into a block starting at a given attribute.    
 ;   Arguments: Enam, the attribute ename.                                 
 ;              Vlasta, a list of attribute values.                        
 ;   Stops when it runs out of attributes or values.                       
 ;   A value of * leaves the existing attribute value unchanged.           
 ;   Returns a list: the name of the first unused attribute or the         
 ;   Seqend, and the unused portion of the new value list.                 
 ; 
 (DEFUN VALIN (enam vlasta / esav entt gnuval)
  (setq esav enam)
  (while (and (/= (cdr (assoc 0 (setq entt (entget enam)))) "SEQEND")
              (setq gnuval (car vlasta)))
         (if (/= gnuval "*")
             (entmod (subst (cons 1 gnuval) (assoc 1 entt) entt)))
         (setq vlasta (cdr vlasta))
         (setq enam (entnext enam)))
  (entupd esav)
 (list enam vlasta))
 ; Ŀ
 ;   Valin end.                                                            
 ; 

 ; Ŀ
 ;   Lili.                                                                 
 ; 
 (DEFUN C:LILI (/ spec dwgs lineno ssdel ends linen1 base sub namlis fils num
                                                   fnam csvlst suba stop enam)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Call ftx to get loose text data.                                      
 ; 
  (command ".zoom" "e")
  (if (and (setq spec (ftx))
           (setq dwgs (car spec))
           (setq lineno (cadr spec))
           (setq ssdel (last spec))
           (setq spec (caddr spec)))
 ; Ŀ
 ;   Forgive the screwy indentation.                                       
 ; 
      (progn
 ; Ŀ
 ;   Make a truncated version of Lineno just in case - neither the         
 ;   excel files nor the model are perfectly consistent with respect to    
 ;   the final dash-delimited substring.                                   
 ;   This casts some doubt on the claims of the mechanical department      
 ;   that model is complete and consistent.                                
 ; 
  (setq ends '("HET" "H&ET" "25H" "25H&ET" "25HET" "25PP" "ET" "38H" "38HET" "38H&ET"
               "50H" "50HET" "50H&ET" ""))
 ; Ŀ
 ;   If the last substring in Lineno is part of Ends, get the base string. 
 ; 
  (if (and (setq linen1 (clast lineno))
           (member (cadr linen1) ends))
      (progn
           (setq base (car linen1))
 ; Ŀ
 ;   Make the list of all likely line number strings using the endings     
 ;   in the list Ends.                                                     
 ; 
           (setq num 0)
           (while (setq sub (nth num ends))
                  (setq num (1+ num))
                  (if (= sub "")
                      (setq namlis (cons base namlis))
                      (setq namlis (cons (strcat base "-" sub) namlis))))))
 ; Ŀ
 ;   Kludgy addendum: if there was no last substring which could be found  
 ;   in the list Ends, make the HET etc. names using the whole Lineno      
 ;   as the base.                                                          
 ; 
  (if (null namlis)
      (progn
           (setq num 0)
           (while (setq sub (nth num ends))
                  (setq num (1+ num))
                  (if (= sub "")
                      (setq namlis (cons lineno namlis))
                      (setq namlis (cons (strcat lineno "-" sub) namlis))))))
 ; Ŀ
 ;   Get a list of .csv files in the current directory.                    
 ; 
  (setq fils (cadr (dirgg "*.csv" (getvar "dwgprefix"))))
 ; Ŀ
 ;   Process any .csv files in the current directory to find the           
 ;   appropriate csv line.                                                 
 ; 
  (setq num 0)
  (while (and (null stop) (setq fnam (nth num fils)))
         (prompt (strcat "Reading file " fnam ".\n"))
         (setq num (1+ num))
         (setq csvlst (lilli fnam))
         (if (or (setq suba (assoc lineno csvlst))
                 (and namlis (setq suba (massoc namlis csvlst))))
             (progn
                  (prompt (strcat "* Using data file " fnam ". *"))
 ; Ŀ
 ;   If we are here then there is a useable data file, so it is safe to    
 ;   erase the text and lines which were found by ftx.                     
 ; 
                  (if ssdel (command ".erase" ssdel ""))
 ; Ŀ
 ;   Use the line number from the drawing rather than from the file.       
 ; 
                  (setq suba (cons lineno (cdr suba)))
                  (setq suba (cons spec suba))
                  (setq suba (append suba (list dwgs)))
                  (setq stop t))))
 ; Ŀ
 ;   Complain if no .csv file was found.                                   
 ; 
  (if (null stop)
      (progn
           (command "redraw")
           (alert (strcat "Nick, you clod.\nYou haven't updated the\n"
                          "csv from the Excel file."))
           (ogre "Lili Failure - no csv file found.")))
 ; Ŀ
 ;   Find the data block, put the data into it.                            
 ; 
  (if (and suba (setq enam (ssname (ssget "x" (list (cons 2 "ISO-DATA"))) 0)))
      (valin (entnext enam) suba)))
 ; Ŀ
 ;   Bitch if there was no loose text - this is mostly to prevent crashes. 
 ; 
      (progn
           (prompt "*** No Loose Text Found. ***")
           (ogre "Lili Failure - no loose text found.")))
 ; Ŀ
 ;   End neatly.                                                           
 ; 
 (princ))